-- name: BA Custom Spray Pack
-- description: Sprays for Moi64

-- Format for Spray Table
-- {"SprayName", "TextureName"}
local SPRAY_TABLE = {
  { "alice",   "aliceknows" },
  { "alien",   "hina" },
  { "aoba",    "aoba1" },
  { "bing",    "bingshoot" },
  { "chise",   "chiseloading" },
  { "fault",   "yoshimi" },
  { "fists",   "kazusa" },
  { "fug",     "binah" },
  { "fuuka",   "fuukaface" },
  { "fun",     "alice" },
  { "gold",    "gold_order" },
  { "gold2",   "izunagold" },
  { "gold3",   "goldmedal" },
  { "hikari",  "hikaripose" },
  { "hi",      "kaede" },
  { "kasumi",  "kasl2d" },
  { "kokona",  "koko" },
  { "koyuki",  "koyuki_frozen" },
  { "koyuki2", "koyukiface" },
  { "laugh",   "arona" },
  { "look",    "aliceyuzu" },
  { "look2",   "lookalice" },
  { "look3",   "lookyuzu" },
  { "mari",    "angrycat" },
  { "mari2",   "angrycat2" },
  { "megu",    "POV" },
  { "michiru", "tanuki" },
  { "mine",    "sena" },
  { "miyu",    "itsover" },
  { "mutsuki", "mutsukiface" },
  { "nohorny", "no_horny" },
  { "nagisa",  "nagisaquestionmark" },
  { "nozomi",  "shock" },
  { "reisa",   "smugreisa" },
  { "rio",     "riosmile" },
  { "seia",    "eosfox" },
  { "seia2",   "seiaface" },
  { "sensei",  "senseitongue" },
  { "smoke",   "hare" },
  { "smugmoi", "momoi1" },
  { "taberu",  "donut" },
  { "wappi",   "sakurako" },
  { "we",      "mine" },
  { "wide",    "wide" },
  { "wide2",   "yourwide" },
  { "yuh",     "natsu" },
  { "toki",    "hurt" },
  { "toki2",   "nah" },
  { "toki3",   "peace" },
  { "toki4",   "sybau" },
  { "izuner",   "izuner" },
  { "izuner2",   "izuner2" },
  { "sensei2",   "sensi" },
  { "yakumo",   "cinema" },
  { "moimoi",    "moimoi" },
  { "goldbad",    "goldbad" },
  { "hareai",    "hareai" },
  { "rabubu",    "rabubu" },
  { "redseia",    "redseia" },
  { "uweuwe",    "uweuwe" },
  { "gitarnin",    "gitarnin" },
}


local function on_mods_loaded()
  if _G.sprayModExists then
    for _, spray in ipairs(SPRAY_TABLE) do
      _G.sprayMod.create_spray(spray[1], get_texture_info(spray[2]))
    end
  else
    print("Spraymod does not exist.")
  end
end


hook_event(HOOK_ON_MODS_LOADED, on_mods_loaded)
